:setvar DatabaseName "RegistryQA"
:setvar MajorReleaseNumber "1"
:setvar MinorReleaseNumber "0"
:setvar PointReleaseNumber "24"
:setvar DeployVersion "20150223.1"
GO
SET ANSI_NULLS, ANSI_PADDING, ANSI_WARNINGS, ARITHABORT, CONCAT_NULL_YIELDS_NULL, QUOTED_IDENTIFIER ON;

SET NUMERIC_ROUNDABORT OFF;



GO
:on error exit
GO
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
SET NOEXEC OFF; 
*/
:setvar __IsSqlCmdEnabled "True"
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON;
    END

GO

PRINT 'Step 7 - Registry.Database.CreateConstraints.sql
Version Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)
BUILD $(DeployVersion)
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

 ';
GO


USE [$(DatabaseName)];


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_ANSWER_FORM_RESPONSE_DETAIL]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_ANSWER_FORM_RESPONSE_DETAIL] FOREIGN KEY ([FORM_RESPONSE_QUESTION_ID]) REFERENCES [AHOBPR].[FORM_RESPONSE_QUESTION] ([FORM_RESPONSE_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_ANSWER_STD_FORM_ANSWER]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_ANSWER_STD_FORM_ANSWER] FOREIGN KEY ([STD_FORM_ANSWER_ID]) REFERENCES [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FormResponseQuestion_FORM_RESPONSE]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_FormResponseQuestion_FORM_RESPONSE] FOREIGN KEY ([FORM_RESPONSE_ID]) REFERENCES [AHOBPR].[FORM_RESPONSE] ([FORM_RESPONSE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FormResponseQuestion_REGISTRANT_DEPLOYMENT_HISTORY]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_FormResponseQuestion_REGISTRANT_DEPLOYMENT_HISTORY] FOREIGN KEY ([REGISTRANT_DEPLOYMENT_ID]) REFERENCES [AHOBPR].[REGISTRANT_DEPLOYMENT] ([REGISTRANT_DEPLOYMENT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FormResponseQuestion_STD_FORM_QUESTION]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_FormResponseQuestion_STD_FORM_QUESTION] FOREIGN KEY ([STD_FORM_QUESTION_ID]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_STATUS_FORM_RESPONSE]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_STATUS] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_STATUS_FORM_RESPONSE] FOREIGN KEY ([FORM_RESPONSE_ID]) REFERENCES [AHOBPR].[FORM_RESPONSE] ([FORM_RESPONSE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_STATUS_STD_FORM_SECTION]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_STATUS] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_STATUS_STD_FORM_SECTION] FOREIGN KEY ([LAST_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_STATUS_STD_FORM_SUB_SECTION]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_STATUS] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_STATUS_STD_FORM_SUB_SECTION] FOREIGN KEY ([LAST_SUB_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_PROCESS_METRICS_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[PROCESS_METRICS] WITH NOCHECK
    ADD CONSTRAINT [FK_PROCESS_METRICS_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_PROCESS_METRICS_STD_PROCESS_METRICS_TYPE]...';


GO
ALTER TABLE [AHOBPR].[PROCESS_METRICS] WITH NOCHECK
    ADD CONSTRAINT [FK_PROCESS_METRICS_STD_PROCESS_METRICS_TYPE] FOREIGN KEY ([STD_PROCESS_METRICS_TYPE_ID]) REFERENCES [AHOBPR].[STD_PROCESS_METRICS_TYPE] ([STD_PROCESS_METRICS_TYPE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_INSTITUTION]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_INSTITUTION] FOREIGN KEY ([STD_INSTITUTION_ID]) REFERENCES [dbo].[STD_INSTITUTION] ([ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_REGISTRANT_STATUS]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_REGISTRANT_STATUS] FOREIGN KEY ([STD_REGISTRANT_STATUS_ID]) REFERENCES [AHOBPR].[STD_REGISTRANT_STATUS] ([STD_REGISTRANT_STATUS_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_SERVICE_STATUS]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_SERVICE_STATUS] FOREIGN KEY ([STD_SERVICE_STATUS_ID]) REFERENCES [AHOBPR].[STD_SERVICE_STATUS] ([STD_SERVICE_STATUS_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_ADDRESS_REGISTRANT_CONTACT_INFO]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_ADDRESS] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_ADDRESS_REGISTRANT_CONTACT_INFO] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT_CONTACT_INFO] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantContactInfo_Registrant]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_CONTACT_INFO] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantContactInfo_Registrant] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_DEPLOYMENT_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantDeployHx_StdBranchOfService]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantDeployHx_StdBranchOfService] FOREIGN KEY ([STD_BRANCH_OF_SERVICE_ID]) REFERENCES [AHOBPR].[STD_BRANCH_OF_SERVICE] ([STD_BRANCH_OF_SERVICE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_EMAIL_REGISTRANT_CONTACT_INFO]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EMAIL] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_EMAIL_REGISTRANT_CONTACT_INFO] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT_CONTACT_INFO] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_EVALUATION_REGISTRANT_EVALUATION]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EVALUATION] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_EVALUATION_REGISTRANT_EVALUATION] FOREIGN KEY ([REGISTRANT_EVALUATION_ID]) REFERENCES [AHOBPR].[REGISTRANT_EVALUATION] ([REGISTRANT_EVALUATION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantEvaluation_DboStdInstituion]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EVALUATION] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantEvaluation_DboStdInstituion] FOREIGN KEY ([STD_INSTITUTION_ID]) REFERENCES [dbo].[STD_INSTITUTION] ([ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantEvaluaton_Registrant]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EVALUATION] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantEvaluaton_Registrant] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantHealthFactor_RegistrantEvaluation]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantHealthFactor_RegistrantEvaluation] FOREIGN KEY ([REGISTRANT_EVALUATION_ID]) REFERENCES [AHOBPR].[REGISTRANT_EVALUATION] ([REGISTRANT_EVALUATION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantHealthFactor_StdHealthFactor]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantHealthFactor_StdHealthFactor] FOREIGN KEY ([STD_HEALTH_FACTOR_ID]) REFERENCES [AHOBPR].[STD_HEALTH_FACTOR] ([STD_HEALTH_FACTOR_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_PHONE_REGISTRANT_CONTACT_INFO]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_PHONE] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_PHONE_REGISTRANT_CONTACT_INFO] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT_CONTACT_INFO] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_INFO_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_RECORD_INFO] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_INFO_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_REGISTRY_FLAG_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_REGISTRY_FLAG_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_REGISTRY_FLAG_STD_REGISTRY_FLAG]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_REGISTRY_FLAG_STD_REGISTRY_FLAG] FOREIGN KEY ([STD_REGISTRY_FLAG_ID]) REFERENCES [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_SERVICE_EPISODE_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_SERVICE_EPISODE_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_ServiceEpisode_StdBranchOfService]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] WITH NOCHECK
    ADD CONSTRAINT [FK_ServiceEpisode_StdBranchOfService] FOREIGN KEY ([STD_BRANCH_OF_SERVICE_ID]) REFERENCES [AHOBPR].[STD_BRANCH_OF_SERVICE] ([STD_BRANCH_OF_SERVICE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_CONCEPT]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_CONCEPT] FOREIGN KEY ([STD_CONCEPT_ID]) REFERENCES [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_FORM_QUESTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM_QUESTION] FOREIGN KEY ([STD_FORM_QUESTION_ID]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_FORM_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM_SECTION] FOREIGN KEY ([STD_FORM_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_FORM_SUB_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM_SUB_SECTION] FOREIGN KEY ([STD_FORM_SUB_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_FIELD_STD_FORM_ANSWER]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER_FIELD] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_FIELD_STD_FORM_ANSWER] FOREIGN KEY ([STD_FORM_ANSWER_ID]) REFERENCES [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_POST_REQ_XREF_STD_FORM_ANSWER]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_POST_REQ_XREF] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_POST_REQ_XREF_STD_FORM_ANSWER] FOREIGN KEY ([STD_FORM_ANSWER_ID]) REFERENCES [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_POST_REQ_XREF_STD_FORM_QUESTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_POST_REQ_XREF] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_POST_REQ_XREF_STD_FORM_QUESTION] FOREIGN KEY ([STD_FORM_QUESTION_ID]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_POST_REQ_XREF_STD_FORM_QUESTION_POST_REQ]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_POST_REQ_XREF] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_POST_REQ_XREF_STD_FORM_QUESTION_POST_REQ] FOREIGN KEY ([STD_FORM_QUESTION_ID_POST_REQ]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_PRE_REQ_XREF_STD_FORM_QUESTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_PRE_REQ_XREF] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_PRE_REQ_XREF_STD_FORM_QUESTION] FOREIGN KEY ([STD_FORM_QUESTION_ID]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_PRE_REQ_XREF_STD_FORM_QUESTION_PRE_REQ]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_PRE_REQ_XREF] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_PRE_REQ_XREF_STD_FORM_QUESTION_PRE_REQ] FOREIGN KEY ([STD_FORM_QUESTION_ID_PRE_REQ]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_QUESTION_STD_CONCEPT]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_QUESTION_STD_CONCEPT] FOREIGN KEY ([STD_CONCEPT_ID]) REFERENCES [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_QUESTION_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_QUESTION_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_QUESTION_STD_FORM_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_QUESTION_STD_FORM_SECTION] FOREIGN KEY ([STD_FORM_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_QUESTION_STD_FORM_SUB_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_QUESTION_STD_FORM_SUB_SECTION] FOREIGN KEY ([STD_FORM_SUB_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_SECTION_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SECTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_SECTION_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_SUB_SECTION_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SUB_SECTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_SUB_SECTION_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_SUB_SECTION_STD_FORM_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SUB_SECTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_SUB_SECTION_STD_FORM_SECTION] FOREIGN KEY ([STD_FORM_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_StdHealthFactor_StdHealthFactorCategory]...';


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR] WITH NOCHECK
    ADD CONSTRAINT [FK_StdHealthFactor_StdHealthFactorCategory] FOREIGN KEY ([STD_HEALTH_FACTOR_CATEGORY_ID]) REFERENCES [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] ([STD_HEALTH_FACTOR_CATEGORY_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_StdRegistryFlag_StdRegistryFlagType]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG] WITH NOCHECK
    ADD CONSTRAINT [FK_StdRegistryFlag_StdRegistryFlagType] FOREIGN KEY ([STD_REGISTRY_FLAG_TYPE_ID]) REFERENCES [AHOBPR].[STD_REGISTRY_FLAG_TYPE] ([STD_REGISTRY_FLAG_TYPE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_TERM_STD_CONCEPT]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_TERM_STD_CONCEPT] FOREIGN KEY ([STD_CONCEPT_ID]) REFERENCES [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_TERM_SYSTEM_STD_TERM]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_TERM_SYSTEM_STD_TERM] FOREIGN KEY ([SYSTEM_STD_TERM_ID]) REFERENCES [AHOBPR].[STD_TERM] ([STD_TERM_ID]);


GO
PRINT N'Checking existing data against newly created constraints';


GO
USE [$(DatabaseName)];


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE] WITH CHECK CHECK CONSTRAINT [FK_FORM_RESPONSE_REGISTRANT];

ALTER TABLE [AHOBPR].[FORM_RESPONSE] WITH CHECK CHECK CONSTRAINT [FK_FORM_RESPONSE_STD_FORM];

ALTER TABLE [AHOBPR].[FORM_RESPONSE_ANSWER] WITH CHECK CHECK CONSTRAINT [FK_FORM_RESPONSE_ANSWER_FORM_RESPONSE_DETAIL];

ALTER TABLE [AHOBPR].[FORM_RESPONSE_ANSWER] WITH CHECK CHECK CONSTRAINT [FK_FORM_RESPONSE_ANSWER_STD_FORM_ANSWER];

ALTER TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] WITH CHECK CHECK CONSTRAINT [FK_FormResponseQuestion_FORM_RESPONSE];

ALTER TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] WITH CHECK CHECK CONSTRAINT [FK_FormResponseQuestion_REGISTRANT_DEPLOYMENT_HISTORY];

ALTER TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] WITH CHECK CHECK CONSTRAINT [FK_FormResponseQuestion_STD_FORM_QUESTION];

ALTER TABLE [AHOBPR].[FORM_RESPONSE_STATUS] WITH CHECK CHECK CONSTRAINT [FK_FORM_RESPONSE_STATUS_FORM_RESPONSE];

ALTER TABLE [AHOBPR].[FORM_RESPONSE_STATUS] WITH CHECK CHECK CONSTRAINT [FK_FORM_RESPONSE_STATUS_STD_FORM_SECTION];

ALTER TABLE [AHOBPR].[FORM_RESPONSE_STATUS] WITH CHECK CHECK CONSTRAINT [FK_FORM_RESPONSE_STATUS_STD_FORM_SUB_SECTION];

ALTER TABLE [AHOBPR].[PROCESS_METRICS] WITH CHECK CHECK CONSTRAINT [FK_PROCESS_METRICS_REGISTRANT];

ALTER TABLE [AHOBPR].[PROCESS_METRICS] WITH CHECK CHECK CONSTRAINT [FK_PROCESS_METRICS_STD_PROCESS_METRICS_TYPE];

ALTER TABLE [AHOBPR].[REGISTRANT] WITH CHECK CHECK CONSTRAINT [FK_REGISTRANT_STD_INSTITUTION];

ALTER TABLE [AHOBPR].[REGISTRANT] WITH CHECK CHECK CONSTRAINT [FK_REGISTRANT_STD_REGISTRANT_STATUS];

ALTER TABLE [AHOBPR].[REGISTRANT] WITH CHECK CHECK CONSTRAINT [FK_REGISTRANT_STD_SERVICE_STATUS];

ALTER TABLE [AHOBPR].[REGISTRANT_ADDRESS] WITH CHECK CHECK CONSTRAINT [FK_REGISTRANT_ADDRESS_REGISTRANT_CONTACT_INFO];

ALTER TABLE [AHOBPR].[REGISTRANT_CONTACT_INFO] WITH CHECK CHECK CONSTRAINT [FK_RegistrantContactInfo_Registrant];

ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] WITH CHECK CHECK CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_REGISTRANT];

ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] WITH CHECK CHECK CONSTRAINT [FK_RegistrantDeployHx_StdBranchOfService];

ALTER TABLE [AHOBPR].[REGISTRANT_EMAIL] WITH CHECK CHECK CONSTRAINT [FK_REGISTRANT_EMAIL_REGISTRANT_CONTACT_INFO];

ALTER TABLE [AHOBPR].[REGISTRANT_EVALUATION] WITH CHECK CHECK CONSTRAINT [FK_REGISTRANT_EVALUATION_REGISTRANT_EVALUATION];

ALTER TABLE [AHOBPR].[REGISTRANT_EVALUATION] WITH CHECK CHECK CONSTRAINT [FK_RegistrantEvaluation_DboStdInstituion];

ALTER TABLE [AHOBPR].[REGISTRANT_EVALUATION] WITH CHECK CHECK CONSTRAINT [FK_RegistrantEvaluaton_Registrant];

ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR] WITH CHECK CHECK CONSTRAINT [FK_RegistrantHealthFactor_RegistrantEvaluation];

ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR] WITH CHECK CHECK CONSTRAINT [FK_RegistrantHealthFactor_StdHealthFactor];

ALTER TABLE [AHOBPR].[REGISTRANT_PHONE] WITH CHECK CHECK CONSTRAINT [FK_REGISTRANT_PHONE_REGISTRANT_CONTACT_INFO];

ALTER TABLE [AHOBPR].[REGISTRANT_RECORD_INFO] WITH CHECK CHECK CONSTRAINT [FK_REGISTRANT_INFO_REGISTRANT];

ALTER TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG] WITH CHECK CHECK CONSTRAINT [FK_REGISTRANT_REGISTRY_FLAG_REGISTRANT];

ALTER TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG] WITH CHECK CHECK CONSTRAINT [FK_REGISTRANT_REGISTRY_FLAG_STD_REGISTRY_FLAG];

ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] WITH CHECK CHECK CONSTRAINT [FK_REGISTRANT_SERVICE_EPISODE_REGISTRANT];

ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] WITH CHECK CHECK CONSTRAINT [FK_ServiceEpisode_StdBranchOfService];

ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_ANSWER_STD_CONCEPT];

ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM];

ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM_QUESTION];

ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM_SECTION];

ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM_SUB_SECTION];

ALTER TABLE [AHOBPR].[STD_FORM_ANSWER_FIELD] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_ANSWER_FIELD_STD_FORM_ANSWER];

ALTER TABLE [AHOBPR].[STD_FORM_POST_REQ_XREF] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_POST_REQ_XREF_STD_FORM_ANSWER];

ALTER TABLE [AHOBPR].[STD_FORM_POST_REQ_XREF] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_POST_REQ_XREF_STD_FORM_QUESTION];

ALTER TABLE [AHOBPR].[STD_FORM_POST_REQ_XREF] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_POST_REQ_XREF_STD_FORM_QUESTION_POST_REQ];

ALTER TABLE [AHOBPR].[STD_FORM_PRE_REQ_XREF] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_PRE_REQ_XREF_STD_FORM_QUESTION];

ALTER TABLE [AHOBPR].[STD_FORM_PRE_REQ_XREF] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_PRE_REQ_XREF_STD_FORM_QUESTION_PRE_REQ];

ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_QUESTION_STD_CONCEPT];

ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_QUESTION_STD_FORM];

ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_QUESTION_STD_FORM_SECTION];

ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_QUESTION_STD_FORM_SUB_SECTION];

ALTER TABLE [AHOBPR].[STD_FORM_SECTION] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_SECTION_STD_FORM];

ALTER TABLE [AHOBPR].[STD_FORM_SUB_SECTION] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_SUB_SECTION_STD_FORM];

ALTER TABLE [AHOBPR].[STD_FORM_SUB_SECTION] WITH CHECK CHECK CONSTRAINT [FK_STD_FORM_SUB_SECTION_STD_FORM_SECTION];

ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR] WITH CHECK CHECK CONSTRAINT [FK_StdHealthFactor_StdHealthFactorCategory];

ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG] WITH CHECK CHECK CONSTRAINT [FK_StdRegistryFlag_StdRegistryFlagType];

ALTER TABLE [AHOBPR].[STD_TERM] WITH CHECK CHECK CONSTRAINT [FK_STD_TERM_STD_CONCEPT];

ALTER TABLE [AHOBPR].[STD_TERM] WITH CHECK CHECK CONSTRAINT [FK_STD_TERM_SYSTEM_STD_TERM];


GO

PRINT 'Write to DatabaseChangeLog...';
GO

INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('$(MajorReleaseNumber)'
           ,'$(MinorReleaseNumber)'
           ,'$(PointReleaseNumber)'
           ,0
           ,'Step 7 - Registry.Database.CreateConstraints.sql'
	         ,'AHOBPR 1.0.24 Create Constraints after loading test data'
           ,'AHOBPR'
           ,GETDATE());
GO

PRINT '';
PRINT 'Step 7 - Registry.Database.CreateConstraints.sql Complete.';
PRINT '';
PRINT 'Completed ' + CAST(GETDATE() AS varchar(20)) + '.';
GO    


GO
